package org.dromara.zjk.expert.expertPaper.domain.bo;

import org.dromara.zjk.expert.expertPaper.domain.ZjkExpertPaper;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import jakarta.validation.constraints.*;

/**
 * 专家论文信息业务对象 zjk_expert_paper
 *
 * @author zhangzhou
 * @date 2024-11-10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkExpertPaper.class, reverseConvertGenerate = false)
public class ZjkExpertPaperBo extends BaseEntity {

    /**
     * id
     */
    @NotNull(message = "id不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long id;

    /**
     * 专家 id
     */
    @NotNull(message = "专家 id不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long expertId;

    /**
     * 论文名称
     */
    @NotBlank(message = "论文名称不能为空", groups = { AddGroup.class, EditGroup.class })
    private String paperName;

    /**
     * 期刊号
     */
    @NotBlank(message = "期刊号不能为空", groups = { AddGroup.class, EditGroup.class })
    private String periodicalNumber;

    /**
     * 论文附件
     */
    @NotBlank(message = "论文附件不能为空", groups = { AddGroup.class, EditGroup.class })
    private String paperPath;


    private String fileName;
}
