package org.dromara.zjk.expert.expertPaper.domain.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.models.security.SecurityScheme;
import org.dromara.zjk.expert.expertPaper.domain.ZjkExpertPaper;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;


/**
 * 专家论文信息视图对象 zjk_expert_paper
 *
 * @author zhangzhou
 * @date 2024-11-10
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkExpertPaper.class)
public class ZjkExpertPaperVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @ExcelProperty(value = "id")
    private Long id;

    /**
     * 专家 id
     */
    @ExcelProperty(value = "专家 id")
    private Long expertId;

    /**
     * 论文名称
     */
    @ExcelProperty(value = "论文名称")
    private String paperName;

    /**
     * 期刊号
     */
    @ExcelProperty(value = "期刊号")
    private String periodicalNumber;

    /**
     * 论文附件
     */
    @ExcelProperty(value = "论文附件")
    private String paperPath;


    /**
     * 文件名
     */
    private String fileName;

    /**
     * 原名
     */
    private String originalName;

    /**
     * URL地址
     */
    private String url;

    private String expertName;

    private Integer type;

    private String invention;

    private String number;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;
}
