package org.dromara.zjk.expert.expertPaper.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import org.dromara.common.mybatis.core.mapper.BaseMapperPlus;
import org.dromara.zjk.expert.expertPaper.domain.ZjkExpertPaper;
import org.dromara.zjk.expert.expertPaper.domain.bo.ZjkExpertPaperBo;
import org.dromara.zjk.expert.expertPaper.domain.vo.ZjkExpertPaperVo;

import java.util.List;

/**
 * 专家论文信息Mapper接口
 *
 * @author zhangzhou
 * @date 2024-11-10
 */
public interface ZjkExpertPaperMapper extends BaseMapperPlus<ZjkExpertPaper, ZjkExpertPaperVo> {


    List<ZjkExpertPaper> selectByExpertId(@Param("expertId") Long expertId);

    Page<ZjkExpertPaperVo> selectVoListJoinExpertId(Page<Object> build, ZjkExpertPaperBo bo);

    List<ZjkExpertPaperVo> paperList(@Param("productId") Long productId, @Param("reviewSn") String reviewSn);

    Long getExpertPaperCount();
}
