package org.dromara.zjk.expert.expertPatent.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.dromara.common.tenant.core.TenantEntity;
import org.dromara.zjk.annotation.PropertyMsg;

import java.io.Serial;

/**
 * 专家专利信息对象 zjk_expert_patent
 *
 * @author zhangzhou
 * @date 2024-11-10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_expert_patent")
public class ZjkExpertPatent extends TenantEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    private Long id;

    /**
     * 专家 id
     */
    private Long expertId;

    /**
     * 专利号
     */
    @PropertyMsg(propertyName = "专利号")
    private String patentNumber;

    /**
     * 发明创造名称
     */
    @PropertyMsg(propertyName = "发明创造名称")
    private String nameInvention;

    /**
     * 附件路径
     */
    @PropertyMsg(propertyName = "专利附件")
    private String patentPath;

    /**
     * 逻辑删除
     */
    private Long delFlag;
    /**
     * 原名
     */
    @TableField(exist = false)
    private String originalName;

    /**
     * 文件后缀名
     */
    @TableField(exist = false)
    private String fileSuffix;

    /**
     * url
     */
    @TableField(exist = false)
    private String url;
    private Long productId;

    private String reviewSn;
}
