package org.dromara.zjk.expert.expertPatent.domain.bo;

import org.dromara.zjk.expert.expertPatent.domain.ZjkExpertPatent;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import jakarta.validation.constraints.*;

/**
 * 专家专利信息业务对象 zjk_expert_patent
 *
 * @author zhangzhou
 * @date 2024-11-10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkExpertPatent.class, reverseConvertGenerate = false)
public class ZjkExpertPatentBo extends BaseEntity {

    /**
     * id
     */
    @NotNull(message = "id不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long id;

    /**
     * 专家 id
     */
    @NotNull(message = "专家 id不能为空", groups = { AddGroup.class, EditGroup.class })
    private Long expertId;

    /**
     * 专利号
     */
    @NotBlank(message = "专利号不能为空", groups = { AddGroup.class, EditGroup.class })
    private String patentNumber;

    /**
     * 发明创造名称
     */
    @NotBlank(message = "发明创造名称不能为空", groups = { AddGroup.class, EditGroup.class })
    private String nameInvention;

    /**
     * 附件路径
     */
    @NotBlank(message = "附件路径不能为空", groups = { AddGroup.class, EditGroup.class })
    private String patentPath;


}
