package org.dromara.zjk.expert.expertPatent.domain.vo;

import org.dromara.zjk.expert.expertPatent.domain.ZjkExpertPatent;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;


/**
 * 专家专利信息视图对象 zjk_expert_patent
 *
 * @author zhangzhou
 * @date 2024-11-10
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkExpertPatent.class)
public class ZjkExpertPatentVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @ExcelProperty(value = "id")
    private Long id;

    /**
     * 专家 id
     */
    @ExcelProperty(value = "专家 id")
    private Long expertId;

    /**
     * 专利号
     */
    @ExcelProperty(value = "专利号")
    private String patentNumber;

    /**
     * 发明创造名称
     */
    @ExcelProperty(value = "发明创造名称")
    private String nameInvention;

    /**
     * 附件路径
     */
    @ExcelProperty(value = "附件路径")
    private String patentPath;

    /**
     * 文件名
     */
    private String fileName;

    /**
     * 原名
     */
    private String originalName;

    /**
     * URL地址
     */
    private String url;

}
