package org.dromara.zjk.expert.expertPatent.service;

import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.zjk.expert.expertPatent.domain.ZjkExpertPatent;
import org.dromara.zjk.expert.expertPatent.domain.bo.ZjkExpertPatentBo;
import org.dromara.zjk.expert.expertPatent.domain.vo.ZjkExpertPatentVo;

import java.util.Collection;
import java.util.List;

/**
 * 专家专利信息Service接口
 *
 * @author zhangzhou
 * @date 2024-11-10
 */
public interface IZjkExpertPatentService {

    /**
     * 查询专家专利信息
     *
     * @param id 主键
     * @return 专家专利信息
     */
    ZjkExpertPatentVo queryById(Long id);

    /**
     * 分页查询专家专利信息列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 专家专利信息分页列表
     */
    TableDataInfo<ZjkExpertPatentVo> queryPageList(ZjkExpertPatentBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的专家专利信息列表
     *
     * @param bo 查询条件
     * @return 专家专利信息列表
     */
    List<ZjkExpertPatentVo> queryList(ZjkExpertPatentBo bo);

    /**
     * 新增专家专利信息
     *
     * @param bo 专家专利信息
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkExpertPatentBo bo);

    /**
     * 修改专家专利信息
     *
     * @param bo 专家专利信息
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkExpertPatentBo bo);

    /**
     * 校验并批量删除专家专利信息信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);

    /**
     * 专家 id 进行 新增专家专利信息
     * @param zjkExpertPatentList
     * @param expertId
     */
    void handleExpertPatents(List<ZjkExpertPatent> zjkExpertPatentList, Long expertId);


    /**
     * 根据专家 id 获取专家专利信息
     * @param expertId
     * @return
     */
    List<ZjkExpertPatent> populateExpertPatentsList(Long expertId);


    List<ZjkExpertPatent> selectByExpertId(Long expertId);


    void deleteByProductId(Long productReviewId);

    boolean saveBatch(List<ZjkExpertPatent> zjkExpertPatentsList);

    List<ZjkExpertPatent> selectListByProductIds(Long zjkProductReviewId);

    List<ZjkExpertPatentVo> patentList(Long productId, String reviewSn);

    Long getExpertPatentCount();
}
