package org.dromara.zjk.expert.expertRecommend.domain.bo;

import io.github.linpeilie.annotations.AutoMapper;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.zjk.expert.expertRecommend.domain.ZjkExpertRecommend;
import org.dromara.zjk.zwy.annotation.EncryptSensitive;

/**
 * 专家推荐信息业务对象 zjk_expert_recommend
 *
 * @author zhangzhou
 * @date 2024-11-10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkExpertRecommend.class, reverseConvertGenerate = false)
public class ZjkExpertRecommendBo extends BaseEntity {

    /**
     * id
     */
    private Long id;

    /**
     * 专家 id
     */
    private Long expertId;

    /**
     * 用户 id
     */
    private Long userId;

    /**
     * 推荐专家姓名
     */
    @NotBlank(message = "推荐专家姓名不能为空", groups = { AddGroup.class, EditGroup.class })
    @Size(max = 20, message = "推荐专家姓名长度不能超过20个字符",groups = { AddGroup.class})
    private String expertName;

    /**
     * 专家手机号
     */
    @EncryptSensitive
    @NotBlank(message = "专家手机号不能为空", groups = { AddGroup.class, EditGroup.class })
    @Size(max = 11, message = "专家手机号长度不能超过11个字符",groups = { AddGroup.class })
    private String expertPhone;

    /**
     * 推荐理由
     */
    @NotBlank(message = "推荐理由不能为空", groups = { AddGroup.class, EditGroup.class })
    @Size(max = 200, message = "推荐理由长度不能超过200个字符")
    private String reason;

    /**
     * 推荐状态 1 待审批 2 通过 3 驳回
     */
    private String status;


}
