package org.dromara.zjk.expert.expertRecommend.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import org.dromara.common.excel.annotation.ExcelDictFormat;
import org.dromara.common.excel.convert.ExcelDictConvert;
import org.dromara.common.sensitive.annotation.Sensitive;
import org.dromara.common.sensitive.core.SensitiveStrategy;
import org.dromara.zjk.expert.expertRecommend.domain.ZjkExpertRecommend;
import org.dromara.zjk.zwy.annotation.EncryptSensitive;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;


/**
 * 专家推荐信息视图对象 zjk_expert_recommend
 *
 * @author zhangzhou
 * @date 2024-11-10
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkExpertRecommend.class)
public class ZjkExpertRecommendVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    private Long id;

    /**
     * 推荐专家姓名
     */
    @ExcelProperty(value = "推荐专家姓名")
    private String expertName;

    /**
     * 专家手机号
     */

    @EncryptSensitive
    @ExcelProperty(value = "专家手机号")
    private String expertPhone;

    /**
     * 推荐理由
     */
    @ExcelProperty(value = "推荐理由")
    private String reason;

    /**
     * 推荐状态 1 待审批 2 通过 3 驳回
     */
    @ExcelProperty(value = "推荐状态 1 待审批 2 通过 3 驳回", converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "expert_status")
    private String status;


    private Date createTime;

    private String hmac;

}
