package org.dromara.zjk.expert.retirementRecords.domain.bo;

import com.alibaba.excel.annotation.ExcelProperty;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;

import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.zjk.zwy.annotation.EncryptSensitive;
import org.dromara.zjk.expert.retirementRecords.domain.ZjkRetirementRecords;

import java.util.Date;

/**
 * 专家退休记录业务对象 zjk_retirement_records
 *
 * @author zhangzhou
 * @date 2024-11-19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkRetirementRecords.class, reverseConvertGenerate = false)
public class ZjkRetirementRecordsBo extends BaseEntity {

    /**
     * id
     */
    private Long id;

    /**
     * 专家 id
     */
    private Long expertId;

    /**
     * 用户 id
     */
    private Long userId;

    /**
     * 退休时间
     */
    private Date retirementTime;

    /**
     * 专家状态 4 离职 5退休
     */
    private String expertStatus;


    /**
     * 离职原因
     */
    private String reason;

    /**
     * 附件
     */
    private String filePath;

    @ExcelProperty(value = "专家姓名")
    private String expertName;

    @ExcelProperty(value = "联系方式")
    private String contact;

    @ExcelProperty(value = "身份证号")
    @EncryptSensitive
    private String idCard;

    @ExcelProperty(value = "工作单位")
    private String workUnit;

}
