package org.dromara.zjk.filter;

import jakarta.servlet.*;
import jakarta.servlet.http.HttpServletRequest;

import java.io.IOException;

public class AuthorizationFilter implements Filter {

    private static final String AUTHORIZATION_KEY = "YOUR_SECRET_KEY";

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
        throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest) request;
        String authorizationCode = httpRequest.getHeader("Authorization");

        if (authorizationCode == null || !authorizationCode.equals(AUTHORIZATION_KEY)) {
            throw new ServletException("Unauthorized access");
        }
        chain.doFilter(request, response);
    }

    @Override
    public void destroy() {
    }
}
