package org.dromara.zjk.learning_world.controller;

import cn.dev33.satoken.annotation.SaCheckRole;
import cn.dev33.satoken.annotation.SaMode;
import lombok.RequiredArgsConstructor;
import org.dromara.common.core.constant.TenantConstants;
import org.dromara.common.core.domain.R;
import org.dromara.common.core.validate.EditGroup;
import org.dromara.common.idempotent.annotation.RepeatSubmit;
import org.dromara.common.log.annotation.Log;
import org.dromara.common.log.enums.BusinessType;
import org.dromara.common.web.core.BaseController;
import org.dromara.zjk.learning_world.domain.bo.ZjkLearningCommunityBo;
import org.dromara.zjk.learning_world.domain.entity.ZjkLearningCommunity;
import org.dromara.zjk.learning_world.domain.vo.ZjkLearningCommunityVo;
import org.dromara.zjk.learning_world.service.IZjkLearningCommunityService;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * 社区管理
 * 前端访问路由地址为:/zjk/learningCommunity
 *
 * @author ygh
 * @date 2024-11-08
 */
@Validated
@RequiredArgsConstructor
@RestController
@RequestMapping("/learningCommunity")
public class ZjkLearningCommunityController extends BaseController {

    private final IZjkLearningCommunityService zjkLearningCommunityService;



    @GetMapping
    @SaCheckRole(value={
        TenantConstants.JG_ROLE_KEY,
        TenantConstants.SUPER_ADMIN_ROLE_KEY,
        TenantConstants.TENANT_ADMIN_ROLE_KEY,
        TenantConstants.EXPERT_ROLE_KEY,
    },mode = SaMode.OR)
    public R<ZjkLearningCommunityVo> getInfo() {
        return R.ok(zjkLearningCommunityService.getLearningCommunity());
    }

    /**
     * 修改社区管理
     */
    @SaCheckRole(value={
        TenantConstants.JG_ROLE_KEY,
        TenantConstants.SUPER_ADMIN_ROLE_KEY,
        TenantConstants.TENANT_ADMIN_ROLE_KEY,
    },mode = SaMode.OR)
    @Log(title = "社区管理", businessType = BusinessType.UPDATE)
    @RepeatSubmit()
    @PostMapping("/update")
    public R<Void> edit(@Validated(EditGroup.class) @RequestBody ZjkLearningCommunityBo bo) {
        return toAjax(zjkLearningCommunityService.updateByBo(bo));
    }

}
