package org.dromara.zjk.learning_world.domain.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.github.linpeilie.annotations.AutoMapper;
import jakarta.validation.constraints.NotBlank;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.dromara.common.core.utils.DateUtils;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.zjk.learning_world.domain.entity.ZjkLearningCommont;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 评论业务对象 zjk_learning_commont
 *
 * @author ygh
 * @date 2024-11-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkLearningCommont.class, reverseConvertGenerate = false)
public class ZjkLearningCommontBo extends BaseEntity {

    /**
     * id
     */
    private Long id;

    /**
     * 资讯id
     */
    private Long informationId;

    /**
     * 评论人
     */
    private Long reviewerId;

    /**
     * 被回复人ID
     */
    private Long replyId;

    /**
     * 评论
     */
    @NotBlank(message = "评论不能为空", groups = { AddGroup.class, EditGroup.class })
    private String comment;


    /**
     * 状态
     */
    private String status;

    /**
     * 备注
     */
    private String remark;

    private Long parentId;

    @JsonFormat(pattern = DateUtils.YYYY_MM_DD_HH_MM_SS,timezone="GMT+8")
    @DateTimeFormat(pattern = DateUtils.YYYY_MM_DD_HH_MM_SS)
    private Date startTime;
    @JsonFormat(pattern = DateUtils.YYYY_MM_DD_HH_MM_SS,timezone="GMT+8")
    @DateTimeFormat(pattern = DateUtils.YYYY_MM_DD_HH_MM_SS)
    private Date endTime;
}
