package org.dromara.zjk.learning_world.domain.bo;

import org.dromara.zjk.learning_world.domain.entity.ZjkLearningCommunity;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import jakarta.validation.constraints.*;

/**
 * 社区管理业务对象 zjk_learning_community
 *
 * @author ygh
 * @date 2024-11-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkLearningCommunity.class, reverseConvertGenerate = false)
public class ZjkLearningCommunityBo extends BaseEntity {

    /**
     * id
     */
    private Long id;

    /**
     * 社区名称
     */
    private String communityName;

    /**
     * 社区介绍
     */
    private String communityIntroduce;

    /**
     * 状态
     */
    private Long status;

    /**
     * 备注
     */
    private String remark;


}
