package org.dromara.zjk.learning_world.domain.bo;

import org.dromara.zjk.learning_world.domain.entity.ZjkLearningCourse;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import jakarta.validation.constraints.*;

import java.util.Date;
import java.util.List;

/**
 * 课程业务对象 zjk_learning_course
 *
 * @author ygh
 * @date 2024-11-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkLearningCourse.class, reverseConvertGenerate = false)
public class ZjkLearningCourseBo extends BaseEntity {

    /**
     * id
     */
    @NotNull(message = "id不能为空", groups = {EditGroup.class })
    private Long id;

    /**
     * 课程名称
     */
    @NotBlank(message = "课程名称不能为空", groups = { AddGroup.class})
    private String courseName;

    /**
     * 课程分类
     */
    @NotBlank(message = "课程分类不能为空", groups = { AddGroup.class})
    private String courseClassify;

    /**
     * 授课方式
     */
    @NotBlank(message = "授课方式不能为空", groups = { AddGroup.class})
    private String teachingType;

    /**
     * 课程简介
     */
    @NotBlank(message = "课程简介不能为空", groups = { AddGroup.class})
    private String courseBrief;

    /**
     * 课程图片
     */
    @NotBlank(message = "课程图片不能为空", groups = { AddGroup.class})
    private String coursePic;

    /**
     * 状态
     */
    @NotBlank(message = "状态不能为空", groups = { AddGroup.class , EditGroup.class})
    private String status;

    /**
     * 备注
     */
    @NotBlank(message = "备注不能为空")
    private String remark;

    /**
     * 附件
     */
    //@NotBlank(message = "附件不能为空", groups = { AddGroup.class})
    private String courseAttachment;
    /**
     * 上下架时间
     */
    private Date takedownTime;

    /**
     * 创建人
     */
    private Long userId;

    /**
     * 领域
     */
    private List<String> performWorkIdList;

    /**
     * 推荐
     */
    private Boolean recommended;


    /**
     * 领域
     */
    private String performWorkId;
}
