package org.dromara.zjk.learning_world.domain.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.github.linpeilie.annotations.AutoMapper;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.zjk.learning_world.domain.entity.ZjkLearningResource;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 资源管理业务对象 zjk_learning_resource
 *
 * @author ygh
 * @date 2024-11-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkLearningResource.class, reverseConvertGenerate = false)
public class ZjkLearningResourceBo extends BaseEntity {

    /**
     * id
     */
    @NotNull(message = "id不能为空", groups = { EditGroup.class })
    private Long id;

    /**
     * 资源编号
     */
    @NotBlank(message = "资源编号不能为空", groups = { AddGroup.class })
    private String resourceName;

    /**
     * 资源分类
     */
    @NotBlank(message = "资源分类不能为空", groups = { AddGroup.class })
    private String resourceClassify;

    /**
     * 资源类型
     */
    @NotBlank(message = "资源类型不能为空", groups = { AddGroup.class})
    private String resourceType;

    /**
     * 资源简介
     */
    @NotBlank(message = "资源简介不能为空", groups = { AddGroup.class})
    private String resourceBrief;

    /**
     * 发布时间
     */
    @NotNull(message = "发布时间不能为空", groups = { AddGroup.class })
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date resourceTime;

    /**
     * 作者
     */
    @NotBlank(message = "作者不能为空", groups = { AddGroup.class })
    private String author;

    /**
     * 发表期刊
     */
    @NotBlank(message = "发表期刊不能为空", groups = { AddGroup.class})
    private String publishJournal;

    /**
     * 期刊号
     */
    @NotBlank(message = "期刊号不能为空", groups = { AddGroup.class })
    private String journalNo;

    /**
     * 论文标题
     */
    @NotBlank(message = "论文标题不能为空", groups = { AddGroup.class })
    private String paperTitle;

    /**
     * 论文附件
     */
    @NotBlank(message = "论文附件不能为空", groups = { AddGroup.class})
    private String paperAccessory;

    /**
     * 状态
     */
    @NotBlank(message = "状态不能为空", groups = { AddGroup.class, EditGroup.class })
    private String status;

    /**
     * 备注
     */
    @NotBlank(message = "备注不能为空")
    private String remark;


    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    /**
     * 上下架时间
     */
    private Date takedownTime;

    /**
     * 创建人
     */
    private Long userId;
}
