package org.dromara.zjk.learning_world.domain.bo;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.dromara.common.core.utils.DateUtils;
import org.dromara.zjk.learning_world.domain.entity.ZjkProblem;
import org.dromara.common.mybatis.core.domain.BaseEntity;
import org.dromara.common.core.validate.AddGroup;
import org.dromara.common.core.validate.EditGroup;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import lombok.EqualsAndHashCode;
import jakarta.validation.constraints.*;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 问题管理业务对象 zjk_problem
 *
 * @author wt
 * @date 2024-11-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@AutoMapper(target = ZjkProblem.class, reverseConvertGenerate = false)
public class ZjkProblemBo extends BaseEntity {

    /**
     * id
     */
    @NotNull(message = "id不能为空", groups = { EditGroup.class })
    private Long id;

    /**
     * 问题标题
     */
    @NotBlank(message = "问题标题不能为空", groups = { AddGroup.class })
    private String problemTitle;

    /**
     * 问题
     */
    @NotBlank(message = "问题不能为空", groups = { AddGroup.class })
    private String problem;

    /**
     * 回复内容
     */
    private String reply;

    /**
     * 提问人
     */
    private Long userId;

    /**
     * 回复人
     */
    private Long replyId;

    /**
     * 提问时间
     */
    private Date problemTime;

    /**
     * 答复时间
     */
    private Date replyTime;

    /**
     * 状态
     */
    private String status;

    /**
     * 备注
     */

    private String remark;

    /**
     * 提问时间
     */
    @JsonFormat(pattern = DateUtils.YYYY_MM_DD_HH_MM_SS,timezone="GMT+8")
    @DateTimeFormat(pattern = DateUtils.YYYY_MM_DD_HH_MM_SS)
    private Date startTime;

    @JsonFormat(pattern = DateUtils.YYYY_MM_DD_HH_MM_SS,timezone="GMT+8")
    @DateTimeFormat(pattern = DateUtils.YYYY_MM_DD_HH_MM_SS)
    private Date endTime;

    /**
     * 回复时间
     */
    @JsonFormat(pattern = DateUtils.YYYY_MM_DD_HH_MM_SS,timezone="GMT+8")
    @DateTimeFormat(pattern = DateUtils.YYYY_MM_DD_HH_MM_SS)
    private Date replyStartTime;

    @JsonFormat(pattern = DateUtils.YYYY_MM_DD_HH_MM_SS,timezone="GMT+8")
    @DateTimeFormat(pattern = DateUtils.YYYY_MM_DD_HH_MM_SS)
    private Date replyEndTime;


    private Long [] ids;
}
