package org.dromara.zjk.learning_world.domain.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import org.dromara.common.tenant.core.TenantEntity;
import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.dromara.zjk.annotation.PropertyMsg;
import java.io.Serial;
import java.util.Date;

/**
 * 评论对象 zjk_learning_commont
 *
 * @author ygh
 * @date 2024-11-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_learning_commont")
public class ZjkLearningCommont extends TenantEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @PropertyMsg(propertyName = "id")
    private Long id;

    /**
     * 资讯id
     */
    @PropertyMsg(propertyName = "information_id")
    private Long informationId;

    /**
     * 评论人
     */
    @PropertyMsg(propertyName = "reviewer_id")
    private Long reviewerId;

    /**
     * 被回复人ID
     */
    @PropertyMsg(propertyName = "reply_id")
    private Long replyId;

    /**
     * 评论
     */
    @PropertyMsg(propertyName = "comment")
    private String comment;

    /**
     * 评论时间
     */
    @PropertyMsg(propertyName = "comment_time")
    private Date commentTime;

    /**
     * 状态
     */
    @PropertyMsg(propertyName = "status")
    private String status;

    /**
     * 备注
     */
    @PropertyMsg(propertyName = "remark")
    private String remark;

    /**
     * 是否删除
     */
    @TableLogic
    @PropertyMsg(propertyName = "del_flag")
    private Long delFlag;

    /**
     * 撤销时间
     */
    @PropertyMsg(propertyName = "takedown_time")
    private Date takedownTime;

    private Long parentId;
}
