package org.dromara.zjk.learning_world.domain.entity;

import org.dromara.common.tenant.core.TenantEntity;
import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

import java.io.Serial;

/**
 * 资源管理对象 zjk_learning_resource
 *
 * @author ygh
 * @date 2024-11-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_learning_resource")
public class ZjkLearningResource extends TenantEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    private Long id;

    /**
     * 资源编号
     */
    private String resourceName;

    /**
     * 资源分类
     */
    private String resourceClassify;

    /**
     * 资源类型
     */
    private String resourceType;

    /**
     * 资源简介
     */
    private String resourceBrief;

    /**
     * 发布时间
     */
    private Date resourceTime;

    /**
     * 作者
     */
    private String author;

    /**
     * 发表期刊
     */
    private String publishJournal;

    /**
     * 期刊号
     */
    private String journalNo;

    /**
     * 论文标题
     */
    private String paperTitle;

    /**
     * 论文附件
     */
    private String paperAccessory;

    /**
     * 是否删除
     */
    @TableLogic
    private Long delFlag;

    /**
     * 状态
     */
    private String status;

    /**
     * 备注
     */
    private String remark;

    /**
     * 上下架时间
     */
    private Date takedownTime;

    /**
     * 创建人
     */
    private Long userId;

}
