package org.dromara.zjk.learning_world.domain.entity;

import org.dromara.common.tenant.core.TenantEntity;
import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

import org.dromara.zjk.annotation.PropertyMsg;
import java.io.Serial;

/**
 * 问题管理对象 zjk_problem
 *
 * @author wt
 * @date 2024-11-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("zjk_problem")
public class ZjkProblem extends TenantEntity {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @PropertyMsg(propertyName = "id")
    private Long id;

    /**
     * 问题标题
     */
    @PropertyMsg(propertyName = "problem_title")
    private String problemTitle;

    /**
     * 问题
     */
    @PropertyMsg(propertyName = "problem")
    private String problem;

    /**
     * 回复内容
     */
    @PropertyMsg(propertyName = "reply")
    private String reply;

    /**
     * 提问人
     */
    @PropertyMsg(propertyName = "user_id")
    private Long userId;

    /**
     * 回复人
     */
    @PropertyMsg(propertyName = "reply_id")
    private Long replyId;

    /**
     * 提问时间
     */
    @PropertyMsg(propertyName = "problem_time")
    private Date problemTime;

    /**
     * 答复时间
     */
    @PropertyMsg(propertyName = "reply_time")
    private Date replyTime;

    /**
     * 状态
     */
    @PropertyMsg(propertyName = "status")
    private String status;

    /**
     * 备注
     */
    @PropertyMsg(propertyName = "remark")
    private String remark;

    /**
     * 是否删除
     */
    @TableLogic
    @PropertyMsg(propertyName = "del_flag")
    private Long delFlag;


}
