package org.dromara.zjk.learning_world.domain.excel;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import org.dromara.zjk.learning_world.domain.entity.ZjkLearningActivity;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;


/**
 * 活动管理视图对象 zjk_learning_activity
 *
 * @author ygh
 * @date 2024-11-08
 */
@Data
public class ZjkLearningActivityExcel   {



    /**
     * 活动名称
     */
    @ExcelProperty(value = "活动名称")
    private String activityName;

    /**
     * 活动分类
     */
    @ExcelIgnore
    private String activityClassify;

    /**
     * 活动分类
     */
    @ExcelProperty(value = "活动分类")
    private String activityClassifyName;

    /**
     * 活动开始时间
     */
    @ExcelProperty(value = "活动开始时间")
    private Date activityStartTime;
    /**
     * 活动结束时间
     */
    @ExcelProperty(value = "活动开始时间")
    private Date activityEndTime;

    /**
     * 活动地点
     */
    @ExcelProperty(value = "活动地点")
    private String activityAddress;

    /**
     * 活动数量
     */
    @ExcelProperty(value = "活动人数")
    private Long activityNum;

    /**
     * 活动内容
     */
    @ExcelProperty(value = "活动内容")
    private String activityContent;

    /**
     * 状态
     */
    @ExcelProperty(value = "发布状态")
    private String status;

    /**
     * 活动状态
     */
    @ExcelIgnore
    private String activityStatus;

    /**
     * 活动状态
     */
    @ExcelProperty(value = "活动状态")
    private String activityStatusName;

    /**
     * 备注
     */
    @ExcelProperty(value = "备注")
    private String remark;


}
