package org.dromara.zjk.learning_world.domain.vo;

import java.util.Date;

import org.dromara.zjk.learning_world.domain.entity.ZjkLearningActivity;
import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;


/**
 * 活动管理视图对象 zjk_learning_activity
 *
 * @author ygh
 * @date 2024-11-08
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkLearningActivity.class)
public class ZjkLearningActivityVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @ExcelProperty(value = "id")
    private Long id;

    /**
     * 活动名称
     */
    @ExcelProperty(value = "活动名称")
    private String activityName;

    /**
     * 活动分类
     */
    @ExcelProperty(value = "活动分类")
    private String activityClassify;

    /**
     * 活动开始时间
     */
    @ExcelProperty(value = "活动开始时间")
    private Date activityStartTime;
    /**
     * 活动结束时间
     */
    @ExcelProperty(value = "活动结束时间")
    private Date activityEndTime;

    /**
     * 活动地点
     */
    @ExcelProperty(value = "活动地点")
    private String activityAddress;

    /**
     * 活动数量
     */
    @ExcelProperty(value = "活动数量")
    private Long activityNum;

    /**
     * 封面图
     */
    @ExcelProperty(value = "封面图")
    private String activityPic;

    /**
     * 活动内容
     */
    @ExcelProperty(value = "活动内容")
    private String activityContent;

    /**
     * 是否发布
     */
    @ExcelProperty(value = "是否发布")
    private String isPublic;

    /**
     * 状态
     */
    @ExcelProperty(value = "状态")
    private String status;

    /**
     * 状态
     */
    @ExcelProperty(value = "活动状态")
    private String activityStatus;


    /**
     * 备注
     */
    @ExcelProperty(value = "备注")
    private String remark;

    @ExcelProperty(value = "用户名称")
    private String userName;

    private String deptName;
    /**
     * 上下架时间
     */
    private Date takedownTime;

    /**
     * 创建人
     */
    private Long userId;
}
