package org.dromara.zjk.learning_world.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import org.dromara.common.translation.annotation.Translation;
import org.dromara.common.translation.constant.TransConstant;
import org.dromara.zjk.annotation.PropertyMsg;
import org.dromara.zjk.learning_world.domain.entity.ZjkLearningInformation;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;


/**
 * 资讯视图对象 zjk_learning_Information
 *
 * @author ygh
 * @date 2024-11-11
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkLearningInformation.class)
public class ZjkLearningInformationVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @ExcelProperty(value = "id")
    private Long id;

    /**
     * 资讯类型
     */
    @ExcelProperty(value = "资讯类型")
    private String informationClassifyId;

    /**
     * 资讯封面
     */
    @ExcelProperty(value = "资讯封面")
    private String informationImage;

    /**
     * 资讯标题
     */
    @ExcelProperty(value = "资讯标题")
    private String informationTitle;

    /**
     * 资讯详情
     */
    @ExcelProperty(value = "资讯详情")
    private String informationDetail;

    /**
     * 状态
     */
    @ExcelProperty(value = "状态")
    private String status;

    /**
     * 备注
     */
    @ExcelProperty(value = "备注")
    private String remark;

    /**
     * 用户id
     */
    @ExcelProperty(value = "用户id")
    private Long userId;

    @ExcelProperty(value = "用户姓名")
    private String userName;

    @PropertyMsg(propertyName = "撤销时间")
    private Date takedownTime;

    @PropertyMsg(propertyName = "评论数量")
    private Integer commentCount;

    @ExcelProperty(value = "部门名称")
    private String deptName;

    @ExcelProperty(value = "头像")
    private String photograph;
    /**
     * 创建时间
     */
    private Date createTime;

}
