package org.dromara.zjk.learning_world.domain.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.github.linpeilie.annotations.AutoMapper;
import lombok.Data;
import org.dromara.zjk.learning_world.domain.entity.ZjkLearningResource;

import java.io.Serial;
import java.io.Serializable;
import java.util.Date;


/**
 * 资源管理视图对象 zjk_learning_resource
 *
 * @author ygh
 * @date 2024-11-08
 */
@Data
@ExcelIgnoreUnannotated
@AutoMapper(target = ZjkLearningResource.class)
public class ZjkLearningResourceVo implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @ExcelProperty(value = "id")
    private Long id;

    /**
     * 资源编号
     */
    @ExcelProperty(value = "资源编号")
    private String resourceName;

    /**
     * 资源分类
     */
    @ExcelProperty(value = "资源分类")
    private String resourceClassify;

    /**
     * 资源类型
     */
    @ExcelProperty(value = "资源类型")
    private String resourceType;

    /**
     * 资源简介
     */
    @ExcelProperty(value = "资源简介")
    private String resourceBrief;

    /**
     * 发布时间
     */
    @ExcelProperty(value = "发布时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date resourceTime;

    /**
     * 作者
     */
    @ExcelProperty(value = "作者")
    private String author;

    /**
     * 发表期刊
     */
    @ExcelProperty(value = "发表期刊")
    private String publishJournal;

    /**
     * 期刊号
     */
    @ExcelProperty(value = "期刊号")
    private String journalNo;

    /**
     * 论文标题
     */
    @ExcelProperty(value = "论文标题")
    private String paperTitle;

    /**
     * 论文附件
     */
    @ExcelProperty(value = "论文附件")
    private String paperAccessory;

    /**
     * 状态
     */
    @ExcelProperty(value = "状态")
    private String status;

    /**
     * 备注
     */
    @ExcelProperty(value = "备注")
    private String remark;

    @ExcelProperty(value = "用户姓名")
    private String userName;

    @ExcelProperty(value = "创建时间")
    private Date createTime;

    @ExcelProperty(value = "修改时间")
    private Date updateTime;

    /**
     * 上下架时间
     */
    private Date takedownTime;

    /**
     * 创建人
     */
    private Long userId;

    /**
     * 附件 url
     */
    private String url;

    /**
     * 附件名称
     */
    private String originalName;
}
