package org.dromara.zjk.learning_world.service;


import org.dromara.zjk.learning_world.domain.bo.ZjkLearningInformationBo;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.zjk.learning_world.domain.vo.ZjkLearningInformationVo;

import java.util.Collection;
import java.util.List;

/**
 * 资讯Service接口
 *
 * @author ygh
 * @date 2024-11-11
 */
public interface IZjkLearningInformationService {

    /**
     * 查询资讯
     *
     * @param id 主键
     * @return 资讯
     */
    ZjkLearningInformationVo queryById(Long id);

    /**
     * 分页查询资讯列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 资讯分页列表
     */
    TableDataInfo<ZjkLearningInformationVo> queryPageList(ZjkLearningInformationBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的资讯列表
     *
     * @param bo 查询条件
     * @return 资讯列表
     */
    List<ZjkLearningInformationVo> queryList(ZjkLearningInformationBo bo);

    /**
     * 新增资讯
     *
     * @param bo 资讯
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkLearningInformationBo bo);

    /**
     * 修改资讯
     *
     * @param bo 资讯
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkLearningInformationBo bo);

    /**
     * 校验并批量删除资讯信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);

    int updateStatus(ZjkLearningInformationBo bo);

    Long getCount();

}
