package org.dromara.zjk.learning_world.service;

import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.zjk.learning_world.domain.bo.ZjkLearningRecordsBo;
import org.dromara.zjk.learning_world.domain.vo.ZjkLearningRecordsVo;

import java.util.Collection;
import java.util.List;

/**
 * 学习记录Service接口
 *
 * @author wt
 * @date 2024-11-26
 */
public interface IZjkLearningRecordsService {

    /**
     * 查询学习记录
     *
     * @param id 主键
     * @return 学习记录
     */
    ZjkLearningRecordsVo queryById(Long id);

    /**
     * 分页查询学习记录列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 学习记录分页列表
     */
    TableDataInfo<ZjkLearningRecordsVo> queryPageList(ZjkLearningRecordsBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的学习记录列表
     *
     * @param bo 查询条件
     * @return 学习记录列表
     */
    List<ZjkLearningRecordsVo> queryList(ZjkLearningRecordsBo bo);

    /**
     * 新增学习记录
     *
     * @param bo 学习记录
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkLearningRecordsBo bo);

    /**
     * 修改学习记录
     *
     * @param bo 学习记录
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkLearningRecordsBo bo);

    /**
     * 校验并批量删除学习记录信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);

    ZjkLearningRecordsVo getInfoByCourseId(Long courseId);

    ZjkLearningRecordsVo compliance();

}
