package org.dromara.zjk.learning_world.service;

import org.dromara.zjk.learning_world.domain.excel.ZjkLearningResourceExcel;
import org.dromara.zjk.learning_world.domain.vo.ZjkLearningResourceVo;
import org.dromara.zjk.learning_world.domain.bo.ZjkLearningResourceBo;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.common.mybatis.core.page.PageQuery;

import java.util.Collection;
import java.util.List;

/**
 * 资源管理Service接口
 *
 * @author ygh
 * @date 2024-11-08
 */
public interface IZjkLearningResourceService {

    /**
     * 查询资源管理
     *
     * @param id 主键
     * @return 资源管理
     */
    ZjkLearningResourceVo queryById(Long id);

    /**
     * 分页查询资源管理列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 资源管理分页列表
     */
    TableDataInfo<ZjkLearningResourceVo> queryPageList(ZjkLearningResourceBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的资源管理列表
     *
     * @param bo 查询条件
     * @return 资源管理列表
     */
    List<ZjkLearningResourceVo> queryList(ZjkLearningResourceBo bo);

    /**
     * 新增资源管理
     *
     * @param bo 资源管理
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkLearningResourceBo bo);

    /**
     * 修改资源管理
     *
     * @param bo 资源管理
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkLearningResourceBo bo);

    /**
     * 校验并批量删除资源管理信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);

    List<ZjkLearningResourceExcel> exportList(ZjkLearningResourceBo bo);

    int updateStatus(ZjkLearningResourceBo bo);
}
