package org.dromara.zjk.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.RequiredArgsConstructor;
import org.dromara.common.core.exception.ServiceException;
import org.dromara.common.core.utils.MapstructUtils;
import org.dromara.common.core.utils.StringUtils;
import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.common.satoken.utils.LoginHelper;
import org.dromara.zjk.learning_world.domain.bo.ZjkLearningToolBo;
import org.dromara.zjk.learning_world.domain.entity.ZjkLearningTool;
import org.dromara.zjk.learning_world.domain.vo.ZjkLearningToolVo;
import org.dromara.zjk.learning_world.mapper.ZjkLearningToolMapper;
import org.dromara.zjk.learning_world.service.IZjkLearningToolService;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 学习工具管理Service业务层处理
 *
 * @author ygh
 * @date 2024-11-10
 */
@RequiredArgsConstructor
@Service
public class ZjkLearningToolServiceImpl implements IZjkLearningToolService {

    private final ZjkLearningToolMapper baseMapper;

    /**
     * 查询学习工具管理
     *
     * @param id 主键
     * @return 学习工具管理
     */
    @Override
    public ZjkLearningToolVo queryById(Long id){
        return baseMapper.queryById(id);
    }

    /**
     * 分页查询学习工具管理列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 学习工具管理分页列表
     */
    @Override
    public TableDataInfo<ZjkLearningToolVo> queryPageList(ZjkLearningToolBo bo, PageQuery pageQuery) {
        Page<ZjkLearningToolVo> result = baseMapper.selectByAll(pageQuery.build(), bo);
        return TableDataInfo.build(result);
    }

    /**
     * 查询符合条件的学习工具管理列表
     *
     * @param bo 查询条件
     * @return 学习工具管理列表
     */
    @Override
    public List<ZjkLearningToolVo> queryList(ZjkLearningToolBo bo) {
        LambdaQueryWrapper<ZjkLearningTool> lqw = buildQueryWrapper(bo);
        return baseMapper.selectVoList(lqw);
    }

    private LambdaQueryWrapper<ZjkLearningTool> buildQueryWrapper(ZjkLearningToolBo bo) {
        Map<String, Object> params = bo.getParams();
        LambdaQueryWrapper<ZjkLearningTool> lqw = Wrappers.lambdaQuery();
        lqw.like(StringUtils.isNotBlank(bo.getName()), ZjkLearningTool::getName, bo.getName());
        lqw.eq(StringUtils.isNotBlank(bo.getAttachment()), ZjkLearningTool::getAttachment, bo.getAttachment());
        lqw.eq(StringUtils.isNotBlank(bo.getStatus()), ZjkLearningTool::getStatus, bo.getStatus());
        return lqw;
    }

    /**
     * 新增学习工具管理
     *
     * @param bo 学习工具管理
     * @return 是否新增成功
     */
    @Override
    public Boolean insertByBo(ZjkLearningToolBo bo) {
        ZjkLearningTool add = MapstructUtils.convert(bo, ZjkLearningTool.class);
        validEntityBeforeSave(add);
        add.setUserId(LoginHelper.getUserId());
        boolean flag = baseMapper.insert(add) > 0;
        if (flag) {
            bo.setId(add.getId());
        }
        return flag;
    }

    /**
     * 修改学习工具管理
     *
     * @param bo 学习工具管理
     * @return 是否修改成功
     */
    @Override
    public Boolean updateByBo(ZjkLearningToolBo bo) {
        ZjkLearningTool update = MapstructUtils.convert(bo, ZjkLearningTool.class);
        validEntityBeforeSave(update);
        return baseMapper.updateById(update) > 0;
    }

    /**
     * 保存前的数据校验
     */
    private void validEntityBeforeSave(ZjkLearningTool entity){
        //TODO 做一些数据校验,如唯一约束
    }

    /**
     * 校验并批量删除学习工具管理信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    @Override
    public Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid) {
        if(isValid){
            //TODO 做一些业务上的校验,判断是否需要校验
        }
        return baseMapper.deleteByIds(ids) > 0;
    }

    @Override
    public int editStatus(ZjkLearningToolBo bo) {
        Long id = bo.getId();
        ZjkLearningTool entity = baseMapper.selectById(id);
        if(entity==null){
            throw new ServiceException("无效id");
        }
        entity.setStatus(bo.getStatus());
        entity.setTakedownTime(new Date());
        return baseMapper.updateById(entity);
    }
}
