package org.dromara.zjk.mapper;

import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import org.apache.ibatis.annotations.Param;
import org.dromara.common.mybatis.core.mapper.BaseMapperPlus;
import org.dromara.zjk.domain.ZjkExpert;
import org.dromara.zjk.domain.ZjkExpertItem;
import org.dromara.zjk.domain.bo.ZjkExpertItemBo;
import org.dromara.zjk.domain.vo.ItemVO;
import org.dromara.zjk.domain.vo.UserVo;
import org.dromara.zjk.domain.vo.ZjkExpertItemVo;

import java.util.Collection;
import java.util.List;

/**
 * 【请填写功能名称】Mapper接口
 *
 * @author ygh
 * @date 2024-10-29
 */
public interface ZjkExpertItemMapper extends BaseMapperPlus<ZjkExpertItem, ZjkExpertItemVo> {

    ItemVO getById(@Param("id") Long id);
    UserVo selectUser(Long expertId);

    List<ZjkExpertItemVo> getByProductIds(@Param("ids") Collection<Long> ids);

    List<String> selectDataList(List<String> list);

    List<ZjkExpertItemVo> expertTop5();

    List<ZjkExpertItemVo> selectBatchByReviewIds(@Param("reviewIds") Collection<Long> idList);

    @InterceptorIgnore(tenantLine = "true")
    ZjkExpertItem getExpertItemInfoByUserIdAndCode(ZjkExpertItemBo zjkExpertItemBo);

    List<ZjkExpertItemVo> selectCancle(@Param("hour") String hour);

    ZjkExpertItem getExpertItemByUserIdAndItemId(@Param("userId") String userId, @Param("itemId") String itemId,@Param("reviewSn") String reviewSn);

    @InterceptorIgnore(tenantLine = "true")
    ZjkExpert selectExpertByCodeAndPhone(@Param("code") String code, @Param("phone") String phone);

    List<ZjkExpertItem> getCheckZjAccetpt(Long id);

    String checkUserPhoneExist(Long id);
}
