package org.dromara.zjk.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import org.dromara.common.core.domain.DateRange;
import org.dromara.common.mybatis.core.mapper.BaseMapperPlus;
import org.dromara.zjk.domain.ExpertBaseInfo;
import org.dromara.zjk.domain.ZjkExpert;
import org.dromara.zjk.domain.bo.ZjkExpertBo;
import org.dromara.zjk.domain.vo.ExpertPerformWorkCountVO;
import org.dromara.zjk.domain.vo.ZjkExpertVo;
import org.dromara.zjk.zwy.annotation.DecryptOperation;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * expertMapper接口
 *
 * @author wangtong
 * @date 2024-10-24
 */
public interface ZjkExpertMapper extends BaseMapperPlus<ZjkExpert, ZjkExpertVo> {



    List<String> selectExistingIdCards(@Param("idCards") List<String> idCards);

    Page<ZjkExpertVo> expertInquiry(@Param("page") Page<ZjkExpertVo> page, @Param("bo")ZjkExpertBo zjkExpertBo);

    Page<ZjkExpertVo> expertList(@Param("page") Page<ZjkExpertVo> page, @Param("bo")ZjkExpertBo zjkExpertBo);

    List<ZjkExpert> selectByIds(@Param("ids") Collection<Long> list);

    List<ZjkExpertVo> selectByUserIds(@Param("ids") Collection<Long> list);


    ZjkExpertVo selectByUserId(@Param("id") Long userId);

    int  updateStatusById(ZjkExpert zjkExpert);

    @DecryptOperation
    List<ZjkExpert> selectExpertAllList();

    String selectDataWorkId(String value,String tandId);

    ExpertBaseInfo getExpertBaseInfo(Long userId);

    List<ExpertPerformWorkCountVO> getExpertPerformWorkCount(DateRange dateRange);

    List<ExpertPerformWorkCountVO> getUnitCount();

    List<ExpertPerformWorkCountVO> getPoliticsCount();

    List<Map<String, Integer>> getAgeRangeStatistics();

    List<Map<String, Integer>> workProfessialYear();

    List<Map<String, Integer>> getApprovalTimeAnalysis(@Param("startTime") String startTime,
                                                       @Param("endTime") String endTime);

    ZjkExpertVo selectZjkExpertVo(ZjkExpert zjkExpert);

    Long getApprovalTimeCountThisYear();

    @DecryptOperation
    List<ZjkExpert> getPhonesById(List<Long> receiveUserIds);

    Long getUserIdByPhone(String tel);

    int updateHmac(ZjkExpert update);

    List<Long> selectIdsByName(String expertName);
}

