package org.dromara.zjk.mapper;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import org.dromara.common.mybatis.core.mapper.BaseMapperPlus;
import org.dromara.zjk.domain.ZjkInvoice;
import org.dromara.zjk.domain.bo.ZjkInvoiceBo;
import org.dromara.zjk.domain.vo.SysOssVo;
import org.dromara.zjk.domain.vo.ZjkExpertVo;
import org.dromara.zjk.domain.vo.ZjkInvoiceVo;

import java.math.BigDecimal;
import java.util.Map;

/**
 * 发票Mapper接口
 *
 * @author mzx
 * @date 2024-12-09
 */
public interface ZjkInvoiceMapper extends BaseMapperPlus<ZjkInvoice, ZjkInvoiceVo> {



    Page<ZjkInvoiceVo> queryPageList(@Param("page") Page<ZjkExpertVo> page, @Param("bo") ZjkInvoiceBo zjkInvoiceBo);

    /**
     * 根据id查询信息
     * @param id
     * @return
     */
    ZjkInvoiceVo selectInfoById(@Param("id") Long id);

    /**
     * 计算所有记录的金额总和
     * @return
     */
    BigDecimal selectTotalMoney();
}
