package org.dromara.zjk.service;

import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.zjk.domain.bo.ZjkApprovalProcessLogsBo;
import org.dromara.zjk.domain.vo.ZjkApprovalProcessLogsVo;

import java.util.Collection;
import java.util.List;

/**
 * 审批流程记录Service接口
 *
 * @author zhangzhou
 * @date 2024-11-06
 */
public interface IZjkApprovalProcessLogsService {

    /**
     * 查询审批流程记录
     *
     * @param id 主键
     * @return 审批流程记录
     */
    ZjkApprovalProcessLogsVo queryById(Long id);

    /**
     * 分页查询审批流程记录列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 审批流程记录分页列表
     */
    TableDataInfo<ZjkApprovalProcessLogsVo> queryPageList(ZjkApprovalProcessLogsBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的审批流程记录列表
     *
     * @param bo 查询条件
     * @return 审批流程记录列表
     */
    List<ZjkApprovalProcessLogsVo> queryList(ZjkApprovalProcessLogsBo bo);

    /**
     * 新增审批流程记录
     *
     * @param bo 审批流程记录
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkApprovalProcessLogsBo bo);

    /**
     * 修改审批流程记录
     *
     * @param bo 审批流程记录
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkApprovalProcessLogsBo bo);

    /**
     * 校验并批量删除审批流程记录信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);


    /**
     * 通用审批记录保存方法
     *
     * @param zjkApprovalProcessLogs 审批记录对象，包含操作项、操作内容、审批意见等信息
     * @return 是否保存成功
     */
    Boolean saveCommonApprovalRecord(String actionItem, String actionContent,String approvalOpinions);
}
