package org.dromara.zjk.service;

import org.dromara.common.core.domain.R;
import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.zjk.domain.bo.ZjkCreditBo;
import org.dromara.zjk.domain.bo.ZjkCreditUserBo;
import org.dromara.zjk.domain.dto.CreditInfoDto;
import org.dromara.zjk.domain.vo.ChartBaseCreditVO;
import org.dromara.zjk.domain.vo.CreditExpertRankVO;
import org.dromara.zjk.domain.vo.ZjkCreditRuleVo;
import org.dromara.zjk.domain.vo.ZjkCreditUserVo;

import java.util.Collection;
import java.util.List;

/**
 * 信用用户管理Service接口
 *
 * @author ygh
 * @date 2024-11-11
 */
public interface IZjkCreditUserService {

    /**
     * 查询信用用户管理
     *
     * @param ID 主键
     * @return 信用用户管理
     */
    ZjkCreditUserVo queryById(String ID);

    /**
     * 分页查询信用用户管理列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 信用用户管理分页列表
     */
    TableDataInfo<ZjkCreditUserVo> queryPageList(ZjkCreditUserBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的信用用户管理列表
     *
     * @param bo 查询条件
     * @return 信用用户管理列表
     */
    List<ZjkCreditUserVo> queryList(ZjkCreditUserBo bo);

    /**
     * 新增信用用户管理
     *
     * @param bo 信用用户管理
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkCreditUserBo bo);

    /**
     * 修改信用用户管理
     *
     * @param bo 信用用户管理
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkCreditUserBo bo);

    /**
     * 校验并批量删除信用用户管理信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<String> ids, Boolean isValid);

    Boolean saveCreditUser(CreditInfoDto creditInfoDto);

    R<CreditExpertRankVO> getExpertPointRank(Integer rangeDay);

    R<List<ZjkCreditRuleVo>> selectUserById(ZjkCreditBo creditId, PageQuery pageQuery);

    R<List<ChartBaseCreditVO>> blacklist(ZjkCreditBo creditBo);

    Boolean creditId(ZjkCreditUserBo bo);

    Boolean moveToBlacklist(ZjkCreditUserBo bo);

    Boolean removeTheBlacklist(ZjkCreditUserBo bo);

    Long getBlacklistCount();

    Long getCount();

}
