package org.dromara.zjk.service;

import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.zjk.domain.bo.ZjkExpertItemBo;
import org.dromara.zjk.domain.bo.ZjkItemExtreationBo;
import org.dromara.zjk.domain.bo.ZjkProjectExpertItemBo;
import org.dromara.zjk.domain.dto.SmsUpEventDto;
import org.dromara.zjk.domain.vo.ZjkExpertItemVo;
import org.dromara.zjk.domain.vo.ZjkExpertVo;
import org.dromara.zjk.domain.vo.ZjkItemExtreationVo;

import java.util.Collection;
import java.util.List;
import java.util.Set;

/**
 * 抽取记录Service接口
 *
 * @author ygh
 * @date 2024-10-29
 */
public interface IZjkExpertItemService {

    /**
     * 查询抽取记录
     *
     * @param id 主键
     * @return 抽取记录
     */
    ZjkExpertItemVo queryById(Long id);

    /**
     * 分页查询抽取记录列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 抽取记录分页列表
     */
    TableDataInfo<ZjkItemExtreationVo> queryPageList(ZjkItemExtreationBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的抽取记录列表
     *
     * @param bo 查询条件
     * @return 抽取记录列表
     */
    List<ZjkExpertItemVo> queryList(ZjkExpertItemBo bo);

    /**
     * 新增抽取记录
     *
     * @param bo 抽取记录
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkExpertItemBo bo);

    /**
     * 修改抽取记录
     *
     * @param bo 抽取记录
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkExpertItemBo bo);

    /**
     * 校验并批量删除抽取记录信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);

    long expertltem(ZjkProjectExpertItemBo zjkProjectExpertItemBo);

    List<ZjkExpertItemVo> getExpertByReviewId(Long reviewId);

    List<ZjkExpertVo> concatenated(String name);

    Set<String> unitList(String name);

    int cancel(ZjkProjectExpertItemBo bo);

    List<ZjkExpertItemVo> expertTop5();

    List<ZjkExpertItemVo> getByReviewId(Long reviewId);


    void handleSmsReply(SmsUpEventDto smsUpEventDto);

    void cancelExpert();

}
