package org.dromara.zjk.service;

import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.zjk.domain.bo.ZjkExpertLogBo;
import org.dromara.zjk.domain.vo.ZjkExpertLogVo;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 入库记录Service接口
 *
 * @author zhangzhou
 * @date 2024-10-31
 */
public interface IZjkExpertLogService {

    /**
     * 查询入库记录
     *
     * @param id 主键
     * @return 入库记录
     */
    ZjkExpertLogVo queryById(Long id);

    /**
     * 分页查询入库记录列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 入库记录分页列表
     */
    TableDataInfo<ZjkExpertLogVo> queryPageList(ZjkExpertLogBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的入库记录列表
     *
     * @param bo 查询条件
     * @return 入库记录列表
     */
    List<ZjkExpertLogVo> queryList(ZjkExpertLogBo bo);

    /**
     * 新增入库记录
     *
     * @param bo 入库记录
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkExpertLogBo bo);

    /**
     * 修改入库记录
     *
     * @param bo 入库记录
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkExpertLogBo bo);

    /**
     * 校验并批量删除入库记录信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);

    List<Map<String, Object>> getApplicationResults(String startTime, String endTime);

}
