package org.dromara.zjk.service;

import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.zjk.domain.ZjkExpertMajor;
import org.dromara.zjk.domain.bo.ZjkExpertMajorBo;
import org.dromara.zjk.domain.vo.ZjkExpertMajorVo;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * 专家库 专业关系表Service接口
 *
 * @author ygh
 * @date 2024-11-01
 */
public interface IZjkExpertMajorService {

    /**
     * 查询专家库 专业关系表
     *
     * @param id 主键
     * @return 专家库 专业关系表
     */
    ZjkExpertMajorVo queryById(Long id);

    /**
     * 分页查询专家库 专业关系表列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 专家库 专业关系表分页列表
     */
    TableDataInfo<ZjkExpertMajorVo> queryPageList(ZjkExpertMajorBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的专家库 专业关系表列表
     *
     * @param bo 查询条件
     * @return 专家库 专业关系表列表
     */
    List<ZjkExpertMajorVo> queryList(ZjkExpertMajorBo bo);

    /**
     * 新增专家库 专业关系表
     *
     * @param bo 专家库 专业关系表
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkExpertMajorBo bo);

    /**
     * 修改专家库 专业关系表
     *
     * @param bo 专家库 专业关系表
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkExpertMajorBo bo);

    /**
     * 校验并批量删除专家库 专业关系表信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);

    /**
     * 根据用户 id  专家 id 进行 新增专业学历信息
     * @param majorList
     * @param expertId
     * @param userId
     */
    void handleExpertMajors(List<ZjkExpertMajor> majorList, Long expertId, Long userId);

    /**
     * 根据用户 id 专家 id 获取专业关系
     * @param userId
     * @param expertId
     * @return
     */
    List<ZjkExpertMajor> populateExpertMajorList(Long userId, Long expertId);

    /**
     *  获取各个学历的专家人数
     */
    List<Map<Integer,Integer>>  getExpertMajorCount();

}
