package org.dromara.zjk.service;

import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.zjk.domain.bo.ZjkExpertMoneyConfigBo;
import org.dromara.zjk.domain.vo.SelectOptionVo;
import org.dromara.zjk.domain.vo.ZjkExpertMoneyConfigVo;
import org.springframework.web.multipart.MultipartFile;

import java.util.Collection;
import java.util.List;

/**
 * 专家费用管理Service接口
 *
 * @author by
 * @date 2024-11-25
 */
public interface IZjkExpertMoneyConfigService {

    /**
     * 查询专家费用管理
     *
     * @param moneyId 主键
     * @return 专家费用管理
     */
    ZjkExpertMoneyConfigVo queryById(Long moneyId);

    /**
     * 分页查询专家费用管理列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 专家费用管理分页列表
     */
    TableDataInfo<ZjkExpertMoneyConfigVo> queryPageList(ZjkExpertMoneyConfigBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的专家费用管理列表
     *
     * @param bo 查询条件
     * @return 专家费用管理列表
     */
    List<ZjkExpertMoneyConfigVo> queryList(ZjkExpertMoneyConfigBo bo);

    /**
     * 新增专家费用管理
     *
     * @param bo 专家费用管理
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkExpertMoneyConfigBo bo);

    /**
     * 修改专家费用管理
     *
     * @param bo 专家费用管理
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkExpertMoneyConfigBo bo);

    /**
     * 校验并批量删除专家费用管理信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);

    List<SelectOptionVo> getExpertMoneyConfig();

    Boolean imports(List<ZjkExpertMoneyConfigVo> vos);
}
