package org.dromara.zjk.service;

import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.zjk.domain.ZjkExpertProfessional;
import org.dromara.zjk.domain.bo.ZjkExpertProfessionalBo;
import org.dromara.zjk.domain.vo.ZjkExpertProfessionalVo;

import java.util.Collection;
import java.util.List;

/**
 * 专家库技术资格关系表Service接口
 *
 * @author zhangzhou
 * @date 2024-11-01
 */
public interface IZjkExpertProfessionalService {

    /**
     * 查询专家库技术资格关系表
     *
     * @param id 主键
     * @return 专家库技术资格关系表
     */
    ZjkExpertProfessionalVo queryById(Long id);

    /**
     * 分页查询专家库技术资格关系表列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 专家库技术资格关系表分页列表
     */
    TableDataInfo<ZjkExpertProfessionalVo> queryPageList(ZjkExpertProfessionalBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的专家库技术资格关系表列表
     *
     * @param bo 查询条件
     * @return 专家库技术资格关系表列表
     */
    List<ZjkExpertProfessionalVo> queryList(ZjkExpertProfessionalBo bo);

    /**
     * 新增专家库技术资格关系表
     *
     * @param bo 专家库技术资格关系表
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkExpertProfessionalBo bo);

    /**
     * 修改专家库技术资格关系表
     *
     * @param bo 专家库技术资格关系表
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkExpertProfessionalBo bo);

    /**
     * 校验并批量删除专家库技术资格关系表信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);

    /**
     * 获取所有的专业技术资格类型
     * @return
     */
    List<String> professionalList();

    /**
     * 根据用户 id  专家 id 进行 新增专业技术资格信息
     * @param zjkExpertProfessionals
     * @param expertId
     * @param userId
     */
    void handleExpertProfessionals(List<ZjkExpertProfessional> zjkExpertProfessionals, Long expertId, Long userId);


    /**
     * 根据用户 id 专家 id 获取专家库技术资格关系表对象
     * @param userId
     * @param expertId
     * @return
     */
    List<ZjkExpertProfessional> populateExpertProfessionalList(Long userId, Long expertId);
}
