package org.dromara.zjk.service;

import org.apache.ibatis.annotations.Param;
import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.zjk.domain.ExpertBaseInfo;
import org.dromara.zjk.domain.ZjkExpert;
import org.dromara.zjk.domain.ZjkExpertItem;
import org.dromara.zjk.domain.bo.ZjkExpertBo;
import org.dromara.zjk.domain.bo.ZjkProjectExpertItemBo;
import org.dromara.zjk.domain.vo.ExpertPerformWorkCountVO;
import org.dromara.zjk.domain.vo.ZjkExpertVo;
import org.dromara.zjk.zwy.annotation.DecryptOperation;
import org.springframework.web.multipart.MultipartFile;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * expertService接口
 *
 * @author wangtong
 * @date 2024-10-24
 */
public interface IZjkExpertService {

    /**
     * 查询expert
     *
     * @param id 主键
     * @return expert
     */
    ZjkExpertVo queryById(Long id);

    /**
     * 分页查询expert列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return expert分页列表
     */
    TableDataInfo<ZjkExpertVo> queryPageList(ZjkExpertBo bo, PageQuery pageQuery);


    /**
     * 查询专家库列表信息
     * @param bo
     * @param pageQuery
     * @return
     */
    TableDataInfo<ZjkExpertVo> expertList(ZjkExpertBo bo, PageQuery pageQuery);

    /**
     * 查询专家查询列表信息
     * @param bo
     * @param pageQuery
     * @return
     */
    TableDataInfo<ZjkExpertVo> expertInquiry(ZjkExpertBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的expert列表
     *
     * @param bo 查询条件
     * @return expert列表
     */
    List<ZjkExpertVo> queryList(ZjkExpertBo bo);


    /**
     * 查询符合条件的expert列表
     *
     * @param bo 查询条件
     * @return expert列表
     */
    List<ZjkExpertVo> exportList(ZjkExpertBo bo);


    /**
     * 新增expert
     *
     * @param bo expert
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkExpertBo bo);

    void refreshHmac(Long expertId);

    Map<String, Object> getExpertObjectById(Long expertId) ;
    /**
     *批量新增
     * @param list
     * @return 是否新增成功
     */
    Boolean insertList(List<ZjkExpertBo> list);

    /**
     * 修改expert
     *
     * @param bo expert
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkExpertBo bo);

    /**
     * 审批
     * @param bo
     * @return
     */
    Boolean approval(ZjkExpertBo bo);

    /**
     * 校验并批量删除expert信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);


    /**
     * 查询expert
     * @param userId 登录用户id
     * @return expert
     */
    ZjkExpertVo queryByUserId(Long userId,Long expertId);
    /**
     * 根据身份证集合 查询是否存在
     * @param idCards
     * @return
     */
    List<String> selectExistingIdCards(@Param("idCards") List<String> idCards);

    List<ZjkExpertVo> queryByExpertltemList(ZjkProjectExpertItemBo zjkProjectExpertItemBo, List<Long> extractioRestrictio, ZjkProjectExpertItemBo bo, Set<ZjkExpertItem> remoZjkExpertItems,List<Long> specifiedExpertList);

    TableDataInfo<ZjkExpertVo> querylist();

    /**
     * 专家申请撤销
     * @param type 1 专家个人信息页面撤销申请  2 专家个人发起页面撤销
     * @return
     */
    Boolean expertQuash(Integer type,String businessKey);

    List<String> imports(MultipartFile file);

    Long getExpertCount();

    ExpertBaseInfo getExpertBaseInfo();


    List<ExpertPerformWorkCountVO> getExpertPerformWorkCount(Integer days);

    List<ExpertPerformWorkCountVO> getUnitCount();

    List<ExpertPerformWorkCountVO> getPoliticsCount();

    List<Map<String, Integer>> getAgeRangeStatistics();

    List<Map<String, Integer>> workProfessialYear();

    List<Map<String, Integer>> getApprovalTimeAnalysis(String startTime,String endTime);

    Long getApprovalTimeCountThisYear();


    List<ZjkExpert> getPhonesById(List<Long> receiveUserIds);

    Long getUserIdByPhone(String tel);

    void fetchRemoteProfessors();
}
