package org.dromara.zjk.service;

import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.zjk.domain.bo.ZjkItemExtreationBo;
import org.dromara.zjk.domain.vo.ZjkItemExtreationVo;

import java.util.Collection;
import java.util.List;

/**
 * 【请填写功能名称】Service接口
 *
 * @author ygh
 * @date 2024-10-29
 */
public interface IZjkItemExtreationService {

    /**
     * 查询【请填写功能名称】
     *
     * @param id 主键
     * @return 【请填写功能名称】
     */
    ZjkItemExtreationVo queryById(Long id);

    /**
     * 分页查询抽取列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 抽取分页列表
     */
    TableDataInfo<ZjkItemExtreationVo> queryPageList(ZjkItemExtreationBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的抽取列表
     *
     * @param bo 查询条件
     * @return 抽取列表
     */
    List<ZjkItemExtreationVo> queryList(ZjkItemExtreationBo bo);

    /**
     * 新增抽取
     *
     * @param bo 抽取
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkItemExtreationBo bo);

    /**
     * 修改抽取
     *
     * @param bo 抽取
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkItemExtreationBo bo);

    /**
     * 校验并批量删除抽取信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);

    ZjkItemExtreationVo queryExtractionById(Long id);
}
