package org.dromara.zjk.service;

import org.dromara.zjk.domain.ZjkLearningCreditRecord;
import org.dromara.zjk.domain.vo.ZjkLearningCreditRecordVo;
import org.dromara.zjk.domain.bo.ZjkLearningCreditRecordBo;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.common.mybatis.core.page.PageQuery;

import java.util.Collection;
import java.util.List;

/**
 * 信用用户学习记录Service接口
 *
 * @author ygh
 * @date 2024-11-26
 */
public interface IZjkLearningCreditRecordService {

    /**
     * 查询信用用户学习记录
     *
     * @param id 主键
     * @return 信用用户学习记录
     */
    List<ZjkLearningCreditRecordVo> queryById(Long id);

    /**
     * 分页查询信用用户学习记录列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 信用用户学习记录分页列表
     */
    TableDataInfo<ZjkLearningCreditRecordVo> queryPageList(ZjkLearningCreditRecordBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的信用用户学习记录列表
     *
     * @param bo 查询条件
     * @return 信用用户学习记录列表
     */
    List<ZjkLearningCreditRecordVo> queryList(ZjkLearningCreditRecordBo bo);

    /**
     * 新增信用用户学习记录
     *
     * @param bo 信用用户学习记录
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkLearningCreditRecordBo bo);

    /**
     * 修改信用用户学习记录
     *
     * @param bo 信用用户学习记录
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkLearningCreditRecordBo bo);

    /**
     * 校验并批量删除信用用户学习记录信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);
}
