package org.dromara.zjk.service;

import org.dromara.zjk.domain.ZjkLearningMaterials;
import org.dromara.zjk.domain.vo.ZjkLearningMaterialsVo;
import org.dromara.zjk.domain.bo.ZjkLearningMaterialsBo;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.common.mybatis.core.page.PageQuery;

import java.util.Collection;
import java.util.List;

/**
 * 信用资料Service接口
 *
 * @author ygh
 * @date 2024-11-26
 */
public interface IZjkLearningMaterialsService {

    /**
     * 查询信用资料
     *
     * @param id 主键
     * @return 信用资料
     */
    ZjkLearningMaterialsVo queryById(Long id);

    /**
     * 分页查询信用资料列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 信用资料分页列表
     */
    TableDataInfo<ZjkLearningMaterialsVo> queryPageList(ZjkLearningMaterialsBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的信用资料列表
     *
     * @param bo 查询条件
     * @return 信用资料列表
     */
    List<ZjkLearningMaterialsVo> queryList(ZjkLearningMaterialsBo bo);

    /**
     * 新增信用资料
     *
     * @param bo 信用资料
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkLearningMaterialsBo bo);

    /**
     * 修改信用资料
     *
     * @param bo 信用资料
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkLearningMaterialsBo bo);

    /**
     * 校验并批量删除信用资料信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);
}
