package org.dromara.zjk.service;

import org.dromara.zjk.domain.ZjkProductReviewsn;
import org.dromara.zjk.domain.vo.ZjkProductReviewsnVo;
import org.dromara.zjk.domain.bo.ZjkProductReviewsnBo;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.common.mybatis.core.page.PageQuery;

import java.util.Collection;
import java.util.List;

/**
 * 项目阶段文档管理Service接口
 *
 * @author wt
 * @date 2024-11-22
 */
public interface IZjkProductReviewsnService {

    /**
     * 查询项目阶段文档管理
     *
     * @param id 主键
     * @return 项目阶段文档管理
     */
    ZjkProductReviewsnVo queryById(Long id);

    /**
     * 分页查询项目阶段文档管理列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 项目阶段文档管理分页列表
     */
    TableDataInfo<ZjkProductReviewsnVo> queryPageList(ZjkProductReviewsnBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的项目阶段文档管理列表
     *
     * @param bo 查询条件
     * @return 项目阶段文档管理列表
     */
    List<ZjkProductReviewsnVo> queryList(ZjkProductReviewsnBo bo);

    /**
     * 新增项目阶段文档管理
     *
     * @param bo 项目阶段文档管理
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkProductReviewsnBo bo);

    /**
     * 修改项目阶段文档管理
     *
     * @param bo 项目阶段文档管理
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkProductReviewsnBo bo);

    /**
     * 校验并批量删除项目阶段文档管理信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);

    boolean deleteByProductId(Long id, String reviewSn);
}
