package org.dromara.zjk.service;

import org.dromara.zjk.domain.ZjkExpert;
import org.dromara.zjk.domain.ZjkProductSummarize;
import org.dromara.zjk.domain.excels.ZjkProductSummarizeExcelVO;
import org.dromara.zjk.domain.vo.AuditVo;
import org.dromara.zjk.domain.vo.ZjkExpertVo;
import org.dromara.zjk.domain.vo.ZjkProductSummarizeVo;
import org.dromara.zjk.domain.bo.ZjkProductSummarizeBo;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.common.mybatis.core.page.PageQuery;

import java.util.Collection;
import java.util.List;

/**
 * 项目总结Service接口
 *
 * @author ygh
 * @date 2024-11-02
 */
public interface IZjkProductSummarizeService {

    /**
     * 查询项目总结
     *
     * @param id 主键
     * @return 项目总结
     */
    ZjkProductSummarizeVo queryById(Long id);

    /**
     * 分页查询项目总结列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 项目总结分页列表
     */
    TableDataInfo<ZjkProductSummarizeVo> queryPageList(ZjkProductSummarizeBo bo, PageQuery pageQuery);

    /**
     * 查询符合条件的项目总结列表
     *
     * @param bo 查询条件
     * @return 项目总结列表
     */
    List<ZjkProductSummarizeVo> queryList(ZjkProductSummarizeBo bo);

    /**
     * 新增项目总结
     *
     * @param bo 项目总结
     * @return 是否新增成功
     */
    Boolean insertByBo(ZjkProductSummarizeBo bo);

    /**
     * 修改项目总结
     *
     * @param bo 项目总结
     * @return 是否修改成功
     */
    Boolean updateByBo(ZjkProductSummarizeBo bo);

    /**
     * 校验并批量删除项目总结信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid);

    int auditSny(AuditVo auditVo);

    List<ZjkExpert> getExpertByReviewId(Long reviewId);

    List<ZjkProductSummarizeVo> getExpertByProductId(Long productId);

    boolean importSummarize(List<ZjkProductSummarizeExcelVO> vos);

    Long getCount();
}
