package org.dromara.zjk.service;

import org.dromara.common.core.domain.R;
import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.zjk.domain.ZjkEvaluate;
import com.baomidou.mybatisplus.extension.service.IService;
import org.dromara.zjk.domain.vo.StsEvaluateNumVO;
import org.dromara.zjk.domain.vo.StsEvaluateVO;
import org.dromara.zjk.domain.vo.StsListVO;
import org.dromara.zjk.domain.vo.ZjkEvaluateVO;

import java.util.List;

/**
* @author EDY
* @description 针对表【zjk_evaluate(专家评价)】的数据库操作Service
* @createDate 2024-11-01 10:11:52
*/
public interface ZjkEvaluateService extends IService<ZjkEvaluate> {
    TableDataInfo<ZjkEvaluateVO> getListToZj(ZjkEvaluateVO bo, PageQuery pageQuery);

    TableDataInfo<ZjkEvaluateVO> getListToOrg(ZjkEvaluateVO bo, PageQuery pageQuery);

    R<Void> addComment(ZjkEvaluateVO bo);

    ZjkEvaluateVO getInfoById(String gid);

    TableDataInfo<ZjkEvaluateVO> test();

    TableDataInfo<ZjkEvaluateVO> getEvaluateListByExpert(ZjkEvaluateVO bo, PageQuery pageQuery);

    TableDataInfo<ZjkEvaluateVO> getListToXm(ZjkEvaluateVO bo, PageQuery pageQuery);

    StsEvaluateNumVO getStsNum();

    R<StsEvaluateVO> getStsChart(Integer rangeMonth);

    TableDataInfo<StsListVO> getStsList(ZjkEvaluateVO bo, PageQuery pageQuery);

    List<StsListVO> selectStsEvaluateList(ZjkEvaluateVO bo);

}
