package org.dromara.zjk.service;

import org.dromara.common.core.domain.R;
import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.zjk.domain.ZjkPointUser;
import com.baomidou.mybatisplus.extension.service.IService;
import org.dromara.zjk.domain.dto.PointInfoDto;
import org.dromara.zjk.domain.dto.PointReqDto;
import org.dromara.zjk.domain.vo.*;

/**
* @author EDY
* @description 针对表【zjk_point_user(积分用户)】的数据库操作Service
* @createDate 2024-11-06 16:29:59
*/
public interface ZjkPointUserService extends IService<ZjkPointUser> {
    boolean savePointInfo(PointInfoDto dto);

    TableDataInfo<PointShowVO> queryPointList(PointReqDto bo, PageQuery pageQuery);

    TableDataInfo<ZjkPointVO> queryPointDetail(PointReqDto bo, PageQuery pageQuery);

    R<Void> deleteRecord(Long id, String expertId);

    R<PointTrendVO> getPointTrend(String dayKey, String expertId);

    R<Void> pointCheck(ZjkPointUser dto);

    R<PointBaseVO> getPointBase();

    R<PointExpertRankVO> getExpertPointRank(Integer rangeDay);

    TableDataInfo<PointShowVO> checkPointList(PointReqDto bo, PageQuery pageQuery);
     void handleWaitCheckPointStatus();

    }
