package org.dromara.zjk.service.impl;

import cn.hutool.core.util.IdUtil;
import org.dromara.common.core.constant.TenantConstants;
import org.dromara.common.core.utils.MapstructUtils;
import org.dromara.common.core.utils.StringUtils;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.common.mybatis.core.page.PageQuery;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import lombok.RequiredArgsConstructor;
import org.dromara.common.satoken.utils.LoginHelper;
import org.dromara.zjk.domain.LearningBack;
import org.dromara.zjk.enums.ApprovalStatusEnum;
import org.dromara.zjk.learning_world.mapper.ZjkLearningCourseMapper;
import org.dromara.zjk.mapper.ZjkExpertMapper;
import org.springframework.stereotype.Service;
import org.dromara.zjk.domain.bo.LearningEvaluateBo;
import org.dromara.zjk.domain.vo.LearningEvaluateVo;
import org.dromara.zjk.domain.LearningEvaluate;
import org.dromara.zjk.mapper.LearningEvaluateMapper;
import org.dromara.zjk.service.ILearningEvaluateService;

import java.util.List;
import java.util.Map;
import java.util.Collection;

/**
 * 【请填写功能名称】Service业务层处理
 *
 * @author ygh
 * @date 2025-07-28
 */
@RequiredArgsConstructor
@Service
public class LearningEvaluateServiceImpl implements ILearningEvaluateService {

    private final LearningEvaluateMapper baseMapper;
    private final ZjkExpertMapper zjkExpertMapper;
    private final ZjkLearningCourseMapper zjkLearningCourseMapper;
    /**
     * 查询【请填写功能名称】
     *
     * @param ID 主键
     * @return 【请填写功能名称】
     */
    @Override
    public LearningEvaluateVo queryById(String ID){
        LearningEvaluateVo res = baseMapper.selectVoById(ID);
        if(res.getCourseId()!=null){
            res.setCourseName(zjkLearningCourseMapper.selectById(res.getCourseId()).getCourseName());
        }
        return res;
    }

    /**
     * 分页查询【请填写功能名称】列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 【请填写功能名称】分页列表
     */
    @Override
    public TableDataInfo<LearningEvaluateVo> queryPageList(LearningEvaluateBo bo, PageQuery pageQuery) {
        boolean contains = LoginHelper.getLoginUser().getRolePermission().contains(TenantConstants.EXPERT_ROLE_KEY);
        LambdaQueryWrapper<LearningEvaluate> lqw = buildQueryWrapper(bo);
        if (contains) {
            lqw.in(LearningEvaluate::getCreateBy, LoginHelper.getUserId());
        }
        if(!StringUtils.isEmpty(bo.getExpertName())){
            List<Long> uids = zjkExpertMapper.selectIdsByName(bo.getExpertName());
            lqw.in(LearningEvaluate::getCreateBy, uids);
        }
        if(!StringUtils.isEmpty(bo.getCourseName())){
            List<Long> cids = zjkLearningCourseMapper.selectIdsByName(bo.getCourseName());
            lqw.in(LearningEvaluate::getCourseId, cids);
        }
        lqw.orderByDesc(LearningEvaluate::getCreateTime);
        Page<LearningEvaluateVo> result = baseMapper.selectVoPage(pageQuery.build(), lqw);
        result.getRecords().stream().forEach(o ->{
            o.setExpertName(zjkExpertMapper.selectByUserId(o.getCreateBy()).getExpertName());
            o.setCourseName(zjkLearningCourseMapper.selectById(o.getCourseId()).getCourseName());
        });
        return TableDataInfo.build(result);
    }

    /**
     * 查询符合条件的【请填写功能名称】列表
     *
     * @param bo 查询条件
     * @return 【请填写功能名称】列表
     */
    @Override
    public List<LearningEvaluateVo> queryList(LearningEvaluateBo bo) {
        LambdaQueryWrapper<LearningEvaluate> lqw = buildQueryWrapper(bo);
        return baseMapper.selectVoList(lqw);
    }

    private LambdaQueryWrapper<LearningEvaluate> buildQueryWrapper(LearningEvaluateBo bo) {
        Map<String, Object> params = bo.getParams();
        LambdaQueryWrapper<LearningEvaluate> lqw = Wrappers.lambdaQuery();
        lqw.eq(StringUtils.isNotBlank(bo.getID()), LearningEvaluate::getID, bo.getID());
        lqw.eq(bo.getCourseId() != null, LearningEvaluate::getCourseId, bo.getCourseId());
        lqw.eq(bo.getDiffLevel() != null, LearningEvaluate::getDiffLevel, bo.getDiffLevel());
        lqw.eq(bo.getGetLevel() != null, LearningEvaluate::getGetLevel, bo.getGetLevel());
        lqw.eq(bo.getFinishTime() != null, LearningEvaluate::getFinishTime, bo.getFinishTime());
        lqw.eq(bo.getCreateBy() != null, LearningEvaluate::getCreateBy, bo.getCreateBy());
        lqw.eq(bo.getCreateTime() != null, LearningEvaluate::getCreateTime, bo.getCreateTime());
        lqw.eq(bo.getUpdateBy() != null, LearningEvaluate::getUpdateBy, bo.getUpdateBy());
        lqw.eq(bo.getUpdateTime() != null, LearningEvaluate::getUpdateTime, bo.getUpdateTime());
        return lqw;
    }

    /**
     * 新增【请填写功能名称】
     *
     * @param bo 【请填写功能名称】
     * @return 是否新增成功
     */
    @Override
    public Boolean insertByBo(LearningEvaluateBo bo) {
        LearningEvaluate add = MapstructUtils.convert(bo, LearningEvaluate.class);
        validEntityBeforeSave(add);
        boolean flag = baseMapper.insert(add) > 0;
        if (flag) {
            bo.setID(add.getID());
        }
        return flag;
    }

    /**
     * 修改【请填写功能名称】
     *
     * @param bo 【请填写功能名称】
     * @return 是否修改成功
     */
    @Override
    public Boolean updateByBo(LearningEvaluateBo bo) {
        LearningEvaluate update = MapstructUtils.convert(bo, LearningEvaluate.class);
        validEntityBeforeSave(update);
        return baseMapper.updateById(update) > 0;
    }

    /**
     * 保存前的数据校验
     */
    private void validEntityBeforeSave(LearningEvaluate entity){
        //TODO 做一些数据校验,如唯一约束
        if (StringUtils.isBlank(entity.getID())) {
            entity.setID(IdUtil.simpleUUID()); // 或使用其他ID生成方式
        }
    }

    /**
     * 校验并批量删除【请填写功能名称】信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    @Override
    public Boolean deleteWithValidByIds(Collection<String> ids, Boolean isValid) {
        if(isValid){
            //TODO 做一些业务上的校验,判断是否需要校验
        }
        return baseMapper.deleteByIds(ids) > 0;
    }
}
