package org.dromara.zjk.service.impl;

import cn.hutool.core.util.IdUtil;
import org.dromara.common.core.utils.MapstructUtils;
import org.dromara.common.core.utils.StringUtils;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.common.mybatis.core.page.PageQuery;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.dromara.zjk.domain.bo.LearningPlanCourseBo;
import org.dromara.zjk.domain.vo.LearningPlanCourseVo;
import org.dromara.zjk.domain.LearningPlanCourse;
import org.dromara.zjk.mapper.LearningPlanCourseMapper;
import org.dromara.zjk.service.ILearningPlanCourseService;

import java.util.List;
import java.util.Map;
import java.util.Collection;

/**
 * 【请填写功能名称】Service业务层处理
 *
 * @author ygh
 * @date 2025-07-28
 */
@RequiredArgsConstructor
@Service
public class LearningPlanCourseServiceImpl implements ILearningPlanCourseService {

    private final LearningPlanCourseMapper baseMapper;

    /**
     * 查询【请填写功能名称】
     *
     * @param ID 主键
     * @return 【请填写功能名称】
     */
    @Override
    public LearningPlanCourseVo queryById(Long ID){
        return baseMapper.selectVoById(ID);
    }

    /**
     * 分页查询【请填写功能名称】列表
     *
     * @param bo        查询条件
     * @param pageQuery 分页参数
     * @return 【请填写功能名称】分页列表
     */
    @Override
    public TableDataInfo<LearningPlanCourseVo> queryPageList(LearningPlanCourseBo bo, PageQuery pageQuery) {
        LambdaQueryWrapper<LearningPlanCourse> lqw = buildQueryWrapper(bo);
        Page<LearningPlanCourseVo> result = baseMapper.selectVoPage(pageQuery.build(), lqw);
        return TableDataInfo.build(result);
    }

    /**
     * 查询符合条件的【请填写功能名称】列表
     *
     * @param bo 查询条件
     * @return 【请填写功能名称】列表
     */
    @Override
    public List<LearningPlanCourseVo> queryList(LearningPlanCourseBo bo) {
        LambdaQueryWrapper<LearningPlanCourse> lqw = buildQueryWrapper(bo);
        return baseMapper.selectVoList(lqw);
    }

    private LambdaQueryWrapper<LearningPlanCourse> buildQueryWrapper(LearningPlanCourseBo bo) {
        Map<String, Object> params = bo.getParams();
        LambdaQueryWrapper<LearningPlanCourse> lqw = Wrappers.lambdaQuery();
        lqw.eq(bo.getID() != null, LearningPlanCourse::getID, bo.getID());
        lqw.eq(StringUtils.isNotBlank(bo.getPlanId()), LearningPlanCourse::getPlanId, bo.getPlanId());
        lqw.eq(bo.getCourseId() != null, LearningPlanCourse::getCourseId, bo.getCourseId());
        lqw.eq(bo.getCreateBy() != null, LearningPlanCourse::getCreateBy, bo.getCreateBy());
        lqw.eq(bo.getCreateTime() != null, LearningPlanCourse::getCreateTime, bo.getCreateTime());
        lqw.eq(bo.getUpdateBy() != null, LearningPlanCourse::getUpdateBy, bo.getUpdateBy());
        lqw.eq(bo.getUpdateTime() != null, LearningPlanCourse::getUpdateTime, bo.getUpdateTime());
        return lqw;
    }

    /**
     * 新增【请填写功能名称】
     *
     * @param bo 【请填写功能名称】
     * @return 是否新增成功
     */
    @Override
    public Boolean insertByBo(LearningPlanCourseBo bo) {
        LearningPlanCourse add = MapstructUtils.convert(bo, LearningPlanCourse.class);
        validEntityBeforeSave(add);
        boolean flag = baseMapper.insert(add) > 0;
        if (flag) {
            bo.setID(add.getID());
        }
        return flag;
    }

    /**
     * 修改【请填写功能名称】
     *
     * @param bo 【请填写功能名称】
     * @return 是否修改成功
     */
    @Override
    public Boolean updateByBo(LearningPlanCourseBo bo) {
        LearningPlanCourse update = MapstructUtils.convert(bo, LearningPlanCourse.class);
        validEntityBeforeSave(update);
        return baseMapper.updateById(update) > 0;
    }

    /**
     * 保存前的数据校验
     */
    private void validEntityBeforeSave(LearningPlanCourse entity){
        //TODO 做一些数据校验,如唯一约束

    }

    /**
     * 校验并批量删除【请填写功能名称】信息
     *
     * @param ids     待删除的主键集合
     * @param isValid 是否进行有效性校验
     * @return 是否删除成功
     */
    @Override
    public Boolean deleteWithValidByIds(Collection<Long> ids, Boolean isValid) {
        if(isValid){
            //TODO 做一些业务上的校验,判断是否需要校验
        }
        return baseMapper.deleteByIds(ids) > 0;
    }
}
