package org.dromara.zjk.service.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.dromara.common.mybatis.core.page.PageQuery;
import org.dromara.common.mybatis.core.page.TableDataInfo;
import org.dromara.zjk.domain.ZjkInvoiceReport;
import org.dromara.zjk.domain.dto.FpReportInQueryDTO;
import org.dromara.zjk.domain.vo.FpReportInVO;
import org.dromara.zjk.domain.vo.ZjkInvoiceReportVO;
import org.dromara.zjk.mapper.ZjkInvoiceReportMapper;
import org.dromara.zjk.service.ZjkInvoiceReportService;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
* @author EDY
* @description 针对表【zjk_invoice_report(发票报表)】的数据库操作Service实现
* @createDate 2025-07-30 11:02:12
*/
@Slf4j
@Service
public class ZjkInvoiceReportServiceImpl extends ServiceImpl<ZjkInvoiceReportMapper, ZjkInvoiceReport>
    implements ZjkInvoiceReportService{

    @Override
    public TableDataInfo<ZjkInvoiceReportVO> queryPageList(ZjkInvoiceReportVO bo, PageQuery pageQuery) {
        IPage<ZjkInvoiceReportVO> result = baseMapper.queryPageList(pageQuery.build(), bo.getReportType());
        return TableDataInfo.build(result);
    }

    @Override
    public TableDataInfo<FpReportInVO> getInfoList(PageQuery pageQuery, FpReportInQueryDTO dto) {
        ZjkInvoiceReport zjkInvoiceReport = baseMapper.selectById(dto.getId());
        dto.setStart(zjkInvoiceReport.getDateRangeStart());
        dto.setEnd(zjkInvoiceReport.getDateRangeEnd());
        IPage<FpReportInVO> result = baseMapper.getInfoList(pageQuery.build(),dto);
        return TableDataInfo.build(result);
    }

    @Override
    public List<FpReportInVO> queryList(FpReportInQueryDTO dto) {
        List<FpReportInVO>  res = baseMapper.queryList(dto);
        return res;
    }

    @Override
    public void handleInvoiceReport(Integer type) {
       List<String> tids = baseMapper.getTenantIds();
       tids.stream().forEach(tid -> {
           handleInvRp(type, tid);

       });
    }

    private void handleInvRp(Integer type,String tenantId) {
        Date now = new Date();
        ZjkInvoiceReport zjkInvoiceReport = new ZjkInvoiceReport();
        zjkInvoiceReport.setTenantId(tenantId);
        if (type == 0) {
            // 月度报表
            Date lastMonthStart = DateUtil.beginOfMonth(DateUtil.offsetMonth(now, -1));
            Date lastMonthEnd = DateUtil.endOfMonth(DateUtil.offsetMonth(now, -1));
            zjkInvoiceReport.setDateRangeStart(lastMonthStart);
            zjkInvoiceReport.setDateRangeEnd(lastMonthEnd);

            // 生成报表编号：FP-20250731-YDTJ
            String dateStr = DateUtil.format(lastMonthEnd, "yyyyMMdd");
            String reportTypeStr = "YDTJ";
            String reportCode = "FP-" + dateStr + "-" + reportTypeStr;

            // 生成报表名称：2025-07发票统计报表
            String reportName = DateUtil.format(lastMonthEnd, "yyyy-MM") + "发票统计报表";

            zjkInvoiceReport.setReportCode(reportCode);
            zjkInvoiceReport.setReportName(reportName);
            zjkInvoiceReport.setReportType(0); // 0表示月度报表

        } else if (type == 1) {
            // 年度报表
            Date lastYearStart = DateUtil.beginOfYear(DateUtil.offsetYear(now, -1));
            Date lastYearEnd = DateUtil.endOfYear(DateUtil.offsetYear(now, -1));
            zjkInvoiceReport.setDateRangeStart(lastYearStart);
            zjkInvoiceReport.setDateRangeEnd(lastYearEnd);

            // 生成报表编号：FP-20241231-NDTJ
            String dateStr = DateUtil.format(lastYearEnd, "yyyyMMdd");
            String reportTypeStr = "NDTJ";
            String reportCode = "FP-" + dateStr + "-" + reportTypeStr;

            // 生成报表名称：2024-发票统计报表
            String reportName = DateUtil.format(lastYearEnd, "yyyy") + "-发票统计报表";

            zjkInvoiceReport.setReportCode(reportCode);
            zjkInvoiceReport.setReportName(reportName);
            zjkInvoiceReport.setReportType(1); // 1表示年度报表
        }

        // 设置其他必要字段
        zjkInvoiceReport.setCreateBy(1l);
        zjkInvoiceReport.setCreateTime(new Date());

        // 保存报表信息
        this.save(zjkInvoiceReport);
        log.info("tannetId为{}生成{}报表完成", tenantId, zjkInvoiceReport.getReportName());
    }

}




