package org.dromara.zjk.service.impl;

import lombok.RequiredArgsConstructor;
import org.dromara.zjk.domain.vo.JgStatisticsVO;
import org.dromara.zjk.service.*;
import org.springframework.stereotype.Service;

@RequiredArgsConstructor
@Service
public class ZjkJgHomeServiceImpl implements ZjkJgHomeService {

    private final IZjkExpertService zjkExpertService;

    private final IZjkCreditUserService zjkCreditUserService;

    private final IZjkReviewPhaseService zjkReviewPhaseService;

    private final IZjkProductSummarizeService zjkProductSummarizeService;

    private final IZjkLeaveService zjkLeaveService;

    @Override
    public JgStatisticsVO getJgStatistics() {
        JgStatisticsVO jgStatisticsVO = new JgStatisticsVO();
        jgStatisticsVO.setTotalRegisteredExperts(zjkExpertService.getExpertCount());
        jgStatisticsVO.setBlacklistedExperts(zjkCreditUserService.getBlacklistCount());
        jgStatisticsVO.setTotalProjectReviews(zjkReviewPhaseService.getReviewCount());
        jgStatisticsVO.setTotalCompletedSummaries(zjkProductSummarizeService.getCount());
        jgStatisticsVO.setOutstandingCreditExperts(zjkCreditUserService.getCount());
        jgStatisticsVO.setTotalExpertLeaves(zjkLeaveService.getStsNum().getData().getProNums());
        return jgStatisticsVO;
    }
}
